/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.resource;

import java.util.Map;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.resource.STAMPResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class STAMPResources {
    public static void init(ResourceSet resourceSet) {
        STAMPResources.initLocalRegistries(resourceSet);
        STAMPResources.initGlobalRegistries();
    }

    public static void initLocalRegistries(ResourceSet resourceSet) {
        STAMPResources.initURIConverterURIMap(resourceSet.getURIConverter().getURIMap());
        STAMPResources.initResourceFactoryRegistry(resourceSet.getResourceFactoryRegistry());
    }

    public static void initGlobalRegistries() {
        STAMPResources.initURIConverterURIMap(URIConverter.URI_MAP);
        STAMPResources.initResourceFactoryRegistry(Resource.Factory.Registry.INSTANCE);
    }

    public static Map<URI, URI> initURIConverterURIMap(Map<URI, URI> uriMap) {
        URI baseURI = URI.createURI((String)STAMPPlugin.INSTANCE.getBaseURL().toString());
        uriMap.put(URI.createURI((String)"pathmap://STAMP_LIBRARIES/"), URI.createURI((String)"model/libraries/").resolve(baseURI));
        return uriMap;
    }

    public static void initResourceFactoryRegistry(Resource.Factory.Registry registry) {
        registry.getExtensionToFactoryMap().put("stamp", STAMPResource.Factory.INSTANCE);
    }

    public static URI getLibraryHCFHintWordSetURI(String fragment) {
        return URI.createURI((String)"pathmap://STAMP_LIBRARIES/HCFHintWordSets.stamp").appendFragment(fragment);
    }

    public static HCFHintWordSet getLibraryHCFHintWordSet(EObject objectContext, String fragment) {
        return (HCFHintWordSet)STAMPResources.getLibraryObject(objectContext, fragment, STAMPPackage.Literals.HCF_HINT_WORD_SET);
    }

    public static HCFHintWordSet createLibraryHCFHintWordSet(String fragment) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return STAMPResources.getLibraryHCFHintWordSet((ResourceSet)resourceSet, fragment);
    }

    public static HCFHintWordSet getLibraryHCFHintWordSet(ResourceSet resourceSet, String fragment) {
        URI uri = STAMPResources.getLibraryHCFHintWordSetURI(fragment);
        EObject eObject = resourceSet.getEObject(uri, true);
        return (HCFHintWordSet)eObject;
    }

    public static EList<HCFHintWordSet> createLibraryDefaultHCFHintWordSets() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return STAMPResources.getLibraryDefaultHCFHintWordSets((ResourceSet)resourceSet);
    }

    public static EList<HCFHintWordSet> getLibraryDefaultHCFHintWordSets(ResourceSet resourceSet) {
        URI uri = STAMPResources.getLibraryHCFHintWordSetURI("_0");
        EObject eObject = resourceSet.getEObject(uri, true);
        STPAAnalysis stpaAnalysis = (STPAAnalysis)eObject;
        return stpaAnalysis.getHCFHintWordSets();
    }

    static EObject getLibraryObject(EObject objectContext, String fragment, EClass eClass) {
        InternalEObject eObject = (InternalEObject)EcoreUtil.create((EClass)eClass);
        eObject.eSetProxyURI(STAMPResources.getLibraryHCFHintWordSetURI(fragment));
        return EcoreUtil.resolve((EObject)eObject, (EObject)objectContext);
    }
}

