/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jviewElement;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionEvent;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.GolfWidgetFactory;
import net.astah.jmodel.BinaryRelationPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.PathPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.StyleSupport;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.jomt.jviewElement.JomtViewElement;
import net.astah.uml2.uml.Constraints;
import net.astah.uml2.uml.Stereotypes;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class PathViewElement
extends JomtViewElement {
    protected static final byte BODY_COLOR = 2;
    protected static final byte FRAME_COLOR = 2;
    protected static final byte KNOB_COLOR = 2;
    protected static final byte SHADOW_COLOR = 7;
    protected GArrow body;
    protected GCurve bodyCurve;
    protected List<CJomtTextNode> constraintNodes;

    protected void initBody() {
        UserObject userObject = (UserObject)this.getModel();
        if (this.body == null) {
            this.body = new GArrow();
            this.body.setShowShadowWhenUnselect(false);
            this.body.setModel((Object)userObject);
            int n2 = 0;
            n2 |= 1;
            this.body.setType(n2 |= 8);
            this.body.setDepth(-3);
            this.body.addNodeSelectionListener((GNodeSelectionListener)this.body);
            this.body.addNodeSelectionListener((GNodeSelectionListener)this);
            this.addNode((GNode)this.body);
        }
        if (this.isCurve() && this.bodyCurve == null) {
            this.bodyCurve = new GCurve(false);
            this.bodyCurve.setShowShadowWhenUnselect(false);
            this.bodyCurve.setModel((Object)userObject);
            this.bodyCurve.setType(9);
            this.bodyCurve.setDepth(-3);
            this.bodyCurve.addNodeSelectionListener((GNodeSelectionListener)this.bodyCurve);
            this.bodyCurve.addNodeSelectionListener((GNodeSelectionListener)this);
            this.addNode((GNode)this.bodyCurve);
            this.body.setVisible(false);
            this.body.setPickable(false);
            this.body.setLevel(-4);
            if (this.body != null && this.body.isSelected()) {
                this.bodyCurve.setSelected(true);
            }
        }
    }

    @Override
    public void updateColor() {
        this.body.setShadowColorNo((byte)7);
        byte by = this.getBodyColorNo();
        if (by != -1) {
            this.body.setBackgroundNo(by);
        }
        CColor cColor = this.getLineColor();
        this.body.setForegroundColor(cColor);
        this.body.setColorNo((byte)2);
        this.body.setKnobColorNo((byte)2);
        if (this.isCurve()) {
            CColor cColor2 = GolfWidgetFactory.instance().createPinkColor();
            this.body.setForegroundColor(cColor2);
            this.bodyCurve.setShadowColorNo((byte)7);
            this.bodyCurve.setForegroundColor(cColor);
            this.bodyCurve.setKnobColorNo((byte)2);
        }
    }

    protected CColor getLineColor() {
        Presentation presentation = ((UserObject)this.getModel()).getPresentation();
        CColor cColor = StyleSupport.getLineColorWithAuto((DiagramElement)presentation);
        if (cColor == null) {
            cColor = GolfWidgetFactory.instance().createCColor(Color.decode("#000000"));
        }
        return cColor;
    }

    protected byte getBodyColorNo() {
        return 2;
    }

    protected boolean isCurve() {
        Presentation presentation = ((UserObject)this.body.getModel()).getPresentation();
        BinaryRelationPresentation binaryRelationPresentation = (BinaryRelationPresentation)presentation;
        return binaryRelationPresentation.isCurve();
    }

    @Override
    public void updateSelectionType() {
        this.body.setSelectionType((byte)3);
        if (this.isCurve()) {
            this.bodyCurve.setSelectionType((byte)3);
        }
    }

    protected void updateBodyDepth(int n2) {
        if (this.isCurve()) {
            this.initBody();
            this.bodyCurve.setDepth(n2 - 1);
        }
        this.body.setDepth(n2);
    }

    public void updateBody() {
        this.updateBodyType();
        this.updateBodyPoints();
    }

    protected void updateBodyType() {
    }

    protected void setBodyType(int n2, int n3) {
        if (this.isCurve()) {
            this.bodyCurve.setType(n2, n3);
            this.body.setType(n2, 0);
        } else {
            this.body.setType(n2, n3);
        }
    }

    protected void setBodyType(int n2) {
        if (this.isCurve()) {
            this.bodyCurve.setType(n2);
        } else {
            this.body.setType(n2);
        }
    }

    protected void setBodyFilled(boolean bl) {
        if (this.isCurve()) {
            this.bodyCurve.setFilled(bl);
        } else {
            this.body.setFilled(bl);
        }
    }

    protected void setBodyRimWidth(int n2) {
        if (this.isCurve()) {
            this.bodyCurve.setRimWidth(n2);
            this.body.setRimWidth(1);
        } else {
            this.body.setRimWidth(n2);
        }
    }

    protected void setBodyRimPattern(byte by) {
        if (this.isCurve()) {
            this.bodyCurve.setRimPattern(by);
            this.body.setRimPattern((byte)0);
        } else {
            this.body.setRimPattern(by);
        }
    }

    protected void setBodyRimPatternScale(int n2) {
        if (this.isCurve()) {
            this.bodyCurve.setRimPatternScale(n2);
        } else {
            this.body.setRimPatternScale(n2);
        }
    }

    protected void setBodyVisible(boolean bl) {
        if (this.isCurve()) {
            this.bodyCurve.setVisible(bl);
        } else {
            this.body.setVisible(bl);
        }
    }

    protected void updateBodyPoints() {
        Presentation presentation = ((UserObject)this.body.getModel()).getPresentation();
        BinaryRelationPresentation binaryRelationPresentation = (BinaryRelationPresentation)presentation;
        Pnt2d[] pnt2dArray = binaryRelationPresentation.getOuterPoints().toArray(new Pnt2d[0]);
        if (pnt2dArray == null || pnt2dArray.length == 0) {
            pnt2dArray = binaryRelationPresentation.getAllPoints().toArray(new Pnt2d[0]);
        }
        if (pnt2dArray != null && pnt2dArray.length != 0) {
            this.body.setPoints(pnt2dArray);
            if (this.isCurve()) {
                this.bodyCurve.setCurve(pnt2dArray[0].x, pnt2dArray[0].y, pnt2dArray[1].x, pnt2dArray[1].y, pnt2dArray[pnt2dArray.length - 2].x, pnt2dArray[pnt2dArray.length - 2].y, pnt2dArray[pnt2dArray.length - 1].x, pnt2dArray[pnt2dArray.length - 1].y);
                this.bodyCurve.setVisible(true);
                this.bodyCurve.setPickable(true);
                this.body.setLevel(-4);
                if (this.body != null && this.body.isVisible() && !this.body.isSelected() && !this.bodyCurve.isSelected()) {
                    this.body.setVisible(false);
                    this.body.setPickable(false);
                }
            } else if (this.bodyCurve != null) {
                this.body.setVisible(true);
                this.body.setPickable(true);
                this.bodyCurve.setVisible(false);
                this.bodyCurve.setPickable(false);
                this.body.setLevel(-1);
            }
        }
    }

    public void setPickable(boolean bl) {
        super.setPickable(bl);
        this.body.setPickable(bl);
        if (this.isCurve()) {
            this.bodyCurve.setPickable(bl);
        }
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        if (this.body == null) {
            return false;
        }
        if (rectangle2d.isEmpty() || this.body.isVisible() && this.body.intersect(rectangle2d)) {
            return true;
        }
        return this.isCurve() && this.bodyCurve.isVisible() && this.bodyCurve.intersect(rectangle2d);
    }

    public boolean alternativeIntersect(Rectangle2d rectangle2d) {
        if (this.body == null) {
            return false;
        }
        if (this.isCurve()) {
            return this.bodyCurve.isVisible() && this.bodyCurve.intersect(rectangle2d);
        }
        return this.body.isVisible() && this.body.intersect(rectangle2d);
    }

    public void selectionChange(GNodeSelectionEvent gNodeSelectionEvent) {
        if (this.isCurve() && (gNodeSelectionEvent.getSource() == this.bodyCurve || gNodeSelectionEvent.getSource() == this.body)) {
            if (gNodeSelectionEvent.isSelected()) {
                this.body.setVisible(true);
                this.body.setPickable(true);
            } else {
                this.body.setVisible(false);
                this.body.setPickable(false);
            }
            this.body.selectionChange(gNodeSelectionEvent.isSelected());
        } else if (gNodeSelectionEvent.getSource() == this.bodyCurve) {
            this.body.selectionChange(gNodeSelectionEvent.isSelected());
        }
        this.selectionChange(gNodeSelectionEvent.isSelected());
    }

    protected void initConstraintNodes() {
        this.initConstraintNodes((byte)0);
    }

    protected void initConstraintNodes(byte by) {
        UserObject userObject = (UserObject)this.getModel();
        Presentation presentation = userObject.getPresentation();
        EObject eObject = presentation.getModel();
        this.initConstraintNodes(eObject, by);
    }

    protected void initConstraintNodes(EObject eObject, byte by) {
        List<Constraint> list = this.getConstraints(eObject);
        if (list.size() == 0 && this.constraintNodes == null) {
            return;
        }
        if (this.constraintNodes == null) {
            this.constraintNodes = new ArrayList<CJomtTextNode>(0);
        }
        int n2 = this.constraintNodes.size();
        if (list.size() < n2) {
            for (int i2 = 0; i2 < n2 - list.size(); ++i2) {
                GNode gNode = (GNode)this.constraintNodes.get(n2 - 1 - i2);
                this.removeNode(gNode);
                this.constraintNodes.remove(n2 - 1 - i2);
            }
        } else if (list.size() > n2) {
            for (int i3 = 0; i3 < list.size() - n2; ++i3) {
                CJomtTextNode cJomtTextNode = JomtWidgetFactory.instance().createJomtTextAreaNode();
                cJomtTextNode.setAlpha(0.0f);
                cJomtTextNode.setLabelPointType(by);
                cJomtTextNode.setDepth(-3);
                cJomtTextNode.setType(this.getConstraintType());
                cJomtTextNode.setSelectable(this.isConstraintSelectable());
                this.constraintNodes.add(cJomtTextNode);
                this.addNode((GNode)cJomtTextNode);
            }
        }
        this.setConstraintUserObjects();
    }

    protected int getConstraintType() {
        int n2 = 0;
        n2 |= 0x40;
        n2 |= 0x40000000;
        return n2 |= 4;
    }

    protected boolean isConstraintSelectable() {
        return true;
    }

    protected void setConstraintUserObjects() {
        if (this.constraintNodes == null) {
            return;
        }
        Presentation presentation = ((UserObject)this.getModel()).getPresentation();
        PathPresentation pathPresentation = (PathPresentation)presentation;
        List<Constraint> list = this.getConstraints(pathPresentation.getModel());
        for (int i2 = 0; i2 < this.constraintNodes.size(); ++i2) {
            CJomtTextNode cJomtTextNode = this.constraintNodes.get(i2);
            Constraint constraint = list.get(i2);
            LabelPresentation labelPresentation = pathPresentation.getConstraintPresentation(i2);
            UserObject userObject = (UserObject)cJomtTextNode.getModel();
            if (userObject != null && userObject.getPresentation() == labelPresentation && userObject.getModel() == constraint) continue;
            cJomtTextNode.setModel((Object)new UserObject((EObject)constraint, (Presentation)labelPresentation));
        }
    }

    protected void updateConstraint() {
        if (this.constraintNodes == null) {
            return;
        }
        Presentation presentation = ((UserObject)this.getModel()).getPresentation();
        PathPresentation pathPresentation = (PathPresentation)presentation;
        for (int i2 = 0; i2 < this.constraintNodes.size(); ++i2) {
            CJomtTextNode cJomtTextNode = this.constraintNodes.get(i2);
            if (pathPresentation.isConstraintVisibility()) {
                LabelPresentation labelPresentation = pathPresentation.getConstraintPresentation(i2);
                if (labelPresentation == null || !labelPresentation.isVisibility()) {
                    cJomtTextNode.setVisible(false);
                    cJomtTextNode.setPickable(false);
                    continue;
                }
                cJomtTextNode.setWrapLine(false);
                cJomtTextNode.setVisible(true);
                cJomtTextNode.setPickable(true);
                cJomtTextNode.setString("{" + labelPresentation.getLabel() + "}");
                cJomtTextNode.setSelectedString(labelPresentation.getLabel());
                cJomtTextNode.setFont(labelPresentation.getFont());
                cJomtTextNode.setRect(labelPresentation.getRect());
                continue;
            }
            cJomtTextNode.setVisible(false);
            cJomtTextNode.setRect(0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void updateConstraintsDepth(int n2) {
        if (this.constraintNodes == null) {
            return;
        }
        for (int i2 = 0; i2 < this.constraintNodes.size(); ++i2) {
            CJomtTextNode cJomtTextNode = this.constraintNodes.get(i2);
            cJomtTextNode.setDepth(n2);
        }
    }

    protected void updateConstraintsSelectionType(byte by) {
        if (this.constraintNodes == null) {
            return;
        }
        for (int i2 = 0; i2 < this.constraintNodes.size(); ++i2) {
            CJomtTextNode cJomtTextNode = this.constraintNodes.get(i2);
            cJomtTextNode.setBodySelectionType(by);
        }
    }

    public void update(Notifier notifier, Object object) {
    }

    @Override
    protected void setStereotypeUserObjects(Element element, Presentation presentation) {
        LabelPresentation labelPresentation;
        UserObject userObject;
        CJomtTextNode cJomtTextNode;
        int n2;
        Presentation presentation2 = ((UserObject)this.getModel()).getPresentation();
        PathPresentation pathPresentation = (PathPresentation)presentation2;
        List list = pathPresentation.getShownStereotypes();
        List<String> list2 = this.getKeywords(element);
        for (n2 = 0; n2 < this.stereotypeNodes.size() - list.size(); ++n2) {
            cJomtTextNode = (CJomtTextNode)this.stereotypeNodes.get(n2);
            userObject = (UserObject)cJomtTextNode.getModel();
            labelPresentation = pathPresentation.getStereotypePresentation(n2);
            if (userObject != null && userObject.getPresentation() == labelPresentation && userObject.getModel() == element) continue;
            cJomtTextNode.setModel((Object)new UserObject((EObject)element, (Presentation)labelPresentation));
        }
        for (n2 = list2.size(); n2 < this.stereotypeNodes.size(); ++n2) {
            cJomtTextNode = (CJomtTextNode)this.stereotypeNodes.get(n2);
            userObject = (UserObject)cJomtTextNode.getModel();
            labelPresentation = (Stereotype)list.get(n2 - list2.size());
            LabelPresentation labelPresentation2 = pathPresentation.getStereotypePresentation(n2);
            if (userObject != null && userObject.getPresentation() == labelPresentation2 && userObject.getModel() == labelPresentation) continue;
            cJomtTextNode.setModel((Object)new UserObject(element.getStereotypeApplication((Stereotype)labelPresentation), (Presentation)labelPresentation2));
        }
    }

    @Override
    protected int getStereotypeType() {
        int n2 = 0;
        n2 |= 0x40;
        n2 |= 0x40000000;
        return n2 |= 4;
    }

    @Override
    protected void updateStereotype() {
        UserObject userObject = (UserObject)this.getModel();
        Presentation presentation = userObject.getPresentation();
        PathPresentation pathPresentation = (PathPresentation)presentation;
        EObject eObject = userObject.getModel();
        if (!(eObject instanceof Element)) {
            return;
        }
        Element element = (Element)eObject;
        List list = pathPresentation.getShownStereotypes();
        List<String> list2 = this.getKeywords(element);
        for (int i2 = 0; i2 < this.stereotypeNodes.size(); ++i2) {
            CJomtTextNode cJomtTextNode = (CJomtTextNode)this.stereotypeNodes.get(i2);
            if (pathPresentation.isShowStereotype()) {
                LabelPresentation labelPresentation = pathPresentation.getStereotypePresentation(i2);
                EObject eObject2 = ((UserObject)cJomtTextNode.getModel()).getModel();
                String string = "";
                if (!Stereotypes.getStereotypeApplications((Element)element).contains(eObject2)) {
                    string = list2.get(i2);
                } else {
                    Stereotype stereotype = (Stereotype)list.get(i2 - list2.size());
                    string = stereotype.getName();
                }
                if (labelPresentation == null || !labelPresentation.isVisibility()) {
                    cJomtTextNode.setVisible(false);
                    cJomtTextNode.setPickable(false);
                    continue;
                }
                cJomtTextNode.setVisible(true);
                cJomtTextNode.setPickable(true);
                cJomtTextNode.setString("<<" + string + ">>");
                cJomtTextNode.setSelectedString(string);
                cJomtTextNode.setFont(labelPresentation.getFont());
                cJomtTextNode.setRect(labelPresentation.getRect());
                continue;
            }
            cJomtTextNode.setVisible(false);
            cJomtTextNode.setRect(0.0, 0.0, 0.0, 0.0);
        }
    }

    public List<CJomtTextNode> getConstraintNodes() {
        return this.constraintNodes;
    }

    protected List<Constraint> getConstraints(EObject eObject) {
        return Constraints.findOwnedConstraints((Element)((Element)eObject));
    }

    @Override
    protected void resortAllTextNode() {
        this.initTextOrder();
        this.clearTextOrder();
    }

    @Override
    public void update() {
    }
}

