/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jviewElement;

import java.awt.Font;
import javax.swing.ImageIcon;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GDropDownButton;
import net.astah.golf.draw.GIconButton;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.PackagePresentation;
import net.astah.jmodel.StyleSupport;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jutil.IconButtonPositionUtil;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jview.IconResource;
import net.astah.jomt.jviewElement.CustomableViewElement;
import net.astah.jomt.jviewElement.SubElementOwner;
import org.eclipse.emf.common.notify.Notifier;

public class PackageViewElement
extends CustomableViewElement
implements SubElementOwner {
    protected static final int COLUMN = 10;
    protected static final double HEAD_HEIGHT = 15.0;
    protected static final double HEAD_EFFECT = 0.4;
    protected GRect frame;
    protected GRect head;
    protected GRect body;
    protected GRect selectionRect;
    protected static final byte FRAME_COLOR = 2;
    protected static final byte KNOB_COLOR = 2;
    protected static final byte SHADOW_COLOR = 7;
    protected static final byte CHAR_COLOR = 2;
    private GDropDownButton a;
    private static Object[] b;

    public PackageViewElement(PackagePresentation packagePresentation) {
        super((LabelPresentation)packagePresentation);
    }

    public void setSelected(boolean bl) {
        this.frame.setSelected(bl);
        this.update();
    }

    @Override
    public void update() {
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        this.setDepth(packagePresentation.getDepth());
        this.init();
        this.updateNormal();
    }

    @Override
    public void update(Notifier notifier, Object object) {
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        if (!packagePresentation.isValid()) {
            return;
        }
        this.update();
    }

    public void updateDepth() {
        int n2 = this.getDepth();
        this.name.setDepth(n2 - 2);
        this.updateStereotypesDepth(n2 - 2);
        this.frame.setDepth(n2 - 1);
        this.body.setDepth(n2 - 1);
        this.head.setDepth(n2);
        this.a(n2 - 1);
        this.updateHyperIconDepth(n2);
        this.updateMiniIconDepth(n2);
    }

    private void a(int n2) {
        if (this.selectionRect != null) {
            this.selectionRect.setDepth(n2);
        }
    }

    @Override
    public void init() {
        this.initFrame();
        this.initHead();
        this.initBody();
        this.initName();
        this.initSelectionRect();
        this.initStereotypeNodes();
        this.initHyperIcon();
        this.updateColor();
        this.updateSelectionType();
        this.updateDepth();
    }

    @Override
    protected void initStereotypeNodes() {
        super.initStereotypeNodes();
        this.enableStereotypeNodes(true);
    }

    protected void initSelectionRect() {
        UserObject userObject = (UserObject)this.getModel();
        PackagePresentation packagePresentation = (PackagePresentation)userObject.getPresentation();
        if (!packagePresentation.getSubElements().isEmpty() && this.selectionRect == null) {
            int n2 = 0;
            n2 |= 4;
            this.selectionRect = new GRect();
            this.selectionRect.setType(n2 |= 1);
            this.selectionRect.setFilled(false);
            this.selectionRect.setAlpha(0.0f);
            this.selectionRect.setModel((Object)userObject);
            this.selectionRect.setDepth(-1);
            this.selectionRect.addNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.selectionRect.addNodeSelectionListener((GNodeSelectionListener)this.head);
            this.selectionRect.addNodeSelectionListener((GNodeSelectionListener)this.body);
            this.addNode((GNode)this.selectionRect);
        }
    }

    protected void initName() {
        UserObject userObject = (UserObject)this.getModel();
        if (this.name == null) {
            this.name = JomtWidgetFactory.instance().createJomtTextFieldNode();
            this.name.setLabelPointType((byte)1);
            this.name.setModel((Object)userObject);
            this.name.setDepth(-3);
            this.name.setAlpha(0.0f);
            int n2 = 0;
            n2 |= 0x40;
            this.name.setType(n2 |= 0x80);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this.name);
            this.addNode((GNode)this.name);
        }
    }

    protected void initBody() {
        UserObject userObject = (UserObject)this.getModel();
        if (this.body == null) {
            this.body = new GRect();
            this.body.setModel((Object)userObject);
            this.body.setFilled(true);
            this.body.setRimWidth(2);
            this.body.setDepth(-2);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this.body);
            this.addNode((GNode)this.body);
        }
    }

    protected void initHead() {
        UserObject userObject = (UserObject)this.getModel();
        if (this.head == null) {
            this.head = new GRect();
            this.head.setModel((Object)userObject);
            this.head.setFilled(true);
            this.head.setDepth(-1);
            this.head.setRimWidth(2);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this.head);
            this.addNode((GNode)this.head);
        }
    }

    protected void initFrame() {
        UserObject userObject = (UserObject)this.getModel();
        if (this.frame == null) {
            int n2 = 0;
            n2 |= 4;
            this.frame = new GRect();
            this.frame.setType(n2 |= 1);
            this.frame.setFilled(false);
            this.frame.setAlpha(0.0f);
            this.frame.setModel((Object)userObject);
            this.frame.setDepth(-1);
            this.frame.setRimWidth(0);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this);
            this.addNode((GNode)this.frame);
        }
    }

    @Override
    public void updateColor() {
        UserObject userObject = (UserObject)this.getModel();
        PackagePresentation packagePresentation = (PackagePresentation)userObject.getPresentation();
        CColor cColor = StyleSupport.getFontColorWithAuto((IStyleMapOwner)packagePresentation);
        if (cColor != null) {
            this.name.setFontColor(cColor);
        } else {
            this.name.setColorNo((byte)2);
        }
        this.name.setKnobColorNo((byte)2);
        this.body.setShadowColorNo((byte)7);
        this.body.setBackgroundColor(StyleSupport.getBodyColorWithAuto((DiagramElement)packagePresentation));
        this.body.setColorNo((byte)2);
        this.head.setShadowColorNo((byte)7);
        this.head.setBackgroundColor(StyleSupport.getBodyColorWithAuto((DiagramElement)packagePresentation));
        this.head.setColorNo((byte)2);
        this.frame.setKnobColorNo((byte)2);
        this.updateStereotypesColor((byte)2, (byte)2);
    }

    @Override
    public void updateSelectionType() {
        this.name.setBodySelectionType((byte)1);
        this.head.setSelectionType((byte)2);
        this.body.setSelectionType((byte)2);
        this.frame.setSelectionType((byte)1);
        this.updateStereotypesSelectionType((byte)1);
    }

    public void updateNormal() {
        this.updateNoramlFrame();
        this.updateNoramlHead();
        this.updateNoramlBody();
        this.updateStereotype();
        this.b();
        this.a();
        this.updateIconButton();
        this.updateColor();
        this.updateHyperIcon();
        this.updateMiniIcon();
    }

    @Override
    protected double getStereotypeX(String string) {
        PackagePresentation packagePresentation = (PackagePresentation)this.getPresentation();
        if (!packagePresentation.isWithinBodyName()) {
            return packagePresentation.getLocation().getX() + 2.0;
        }
        return super.getStereotypeX(string);
    }

    @Override
    protected double getStereotypeY(UserObject userObject, int n2) {
        PackagePresentation packagePresentation = (PackagePresentation)this.getPresentation();
        if (packagePresentation.isWithinBodyName()) {
            return this.getStereotypeStartY() + (double)n2 * packagePresentation.getLabelHeight();
        }
        return packagePresentation.getLocation().getY() + (double)n2 * packagePresentation.getLabelHeight();
    }

    @Override
    protected double getStereotypeW(String string) {
        PackagePresentation packagePresentation = (PackagePresentation)this.getPresentation();
        if (!packagePresentation.isWithinBodyName()) {
            return this.head.getWidth() - 4.0;
        }
        return super.getStereotypeW(string);
    }

    private void a() {
        if (this.selectionRect != null) {
            PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
            Pnt2d pnt2d = packagePresentation.getLocation();
            double d2 = packagePresentation.getWidth();
            double d3 = packagePresentation.getStereotypesHeight() + packagePresentation.getLabelHeight();
            if (packagePresentation.isWithinBodyName()) {
                d3 += 20.0;
            }
            this.selectionRect.setVisible(true);
            this.selectionRect.setPickable(true);
            this.selectionRect.setRect(pnt2d.x, pnt2d.y, d2, d3);
            this.selectionRect.setSelectable(true);
        }
    }

    private void b() {
        double d2;
        double d3;
        double d4;
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        Pnt2d pnt2d = packagePresentation.getLocation();
        this.name.setString(packagePresentation.getLabel());
        this.name.setSelectedString(packagePresentation.getName());
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.class.set_font_bold");
        Font font = JomtFontUtilities.getFontForLabel((LabelPresentation)packagePresentation, (boolean)bl);
        this.name.setFont(font);
        if (packagePresentation.isWithinBodyName()) {
            d4 = pnt2d.x + 10.0;
            d3 = pnt2d.y + 20.0 + packagePresentation.getStereotypesHeight();
            d2 = packagePresentation.getWidth() - 20.0;
        } else {
            d4 = pnt2d.x + 2.0;
            d3 = pnt2d.y + packagePresentation.getStereotypesHeight();
            d2 = this.head.getWidth() - 4.0;
        }
        double d5 = packagePresentation.getLabelHeight();
        this.name.setRect(new Rectangle2d(d4, d3, d2, d5));
    }

    protected void updateNoramlBody() {
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        Pnt2d pnt2d = packagePresentation.getLocation();
        if (packagePresentation.isWithinBodyName()) {
            this.body.setPoint(pnt2d.x, pnt2d.y + 15.0);
            this.body.setWidth(packagePresentation.getWidth());
            this.body.setHeight(packagePresentation.getHeight() - 15.0);
        } else {
            this.body.setPoint(pnt2d.x, pnt2d.y + this.head.getHeight());
            this.body.setWidth(packagePresentation.getWidth());
            this.body.setHeight(packagePresentation.getHeight() - this.head.getHeight());
        }
    }

    protected void updateNoramlHead() {
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        Pnt2d pnt2d = packagePresentation.getLocation();
        this.head.setPoint(pnt2d.x, pnt2d.y);
        if (packagePresentation.isWithinBodyName()) {
            this.head.setWidth(packagePresentation.getWidth() * 0.4);
            this.head.setHeight(15.0);
        } else {
            this.head.setWidth(packagePresentation.getNameAndStereotypeWidth());
            this.head.setHeight(packagePresentation.getNameAndStereotypeHeight());
        }
    }

    protected void updateNoramlFrame() {
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        Pnt2d pnt2d = packagePresentation.getLocation();
        double d2 = packagePresentation.getWidth();
        double d3 = packagePresentation.getHeight();
        if (!packagePresentation.getSubElements().isEmpty()) {
            this.frame.setRimmedPick(true);
        } else {
            this.frame.setRimmedPick(false);
        }
        this.frame.setVisible(true);
        this.frame.setPickable(true);
        this.frame.setRect(pnt2d.x, pnt2d.y, d2, d3);
        this.frame.setSelectable(true);
    }

    @Override
    protected double getStereotypeStartY() {
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        Pnt2d pnt2d = packagePresentation.getLocation();
        return pnt2d.y + 20.0;
    }

    @Override
    public Rectangle2d getNonselectionArea() {
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        Pnt2d pnt2d = packagePresentation.getLocation();
        double d2 = packagePresentation.getStereotypesHeight() + packagePresentation.getLabelHeight();
        if (packagePresentation.isWithinBodyName()) {
            d2 += 20.0;
        }
        double d3 = pnt2d.x;
        double d4 = pnt2d.y + d2;
        double d5 = packagePresentation.getWidth();
        double d6 = packagePresentation.getHeight() - d2;
        return new Rectangle2d(d3, d4, d5, d6);
    }

    @Override
    protected void updateIconButton() {
        this.c();
        this.e();
        this.updateIconButtonDepth(this.getDepth() - 2);
    }

    private void c() {
        this.d();
    }

    private void d() {
        if (this.a == null) {
            SwingImageIcon swingImageIcon = new SwingImageIcon((ImageIcon)IconResource.getNormalSizeContainmentIcon());
            this.a = new GDropDownButton((CImageIcon)swingImageIcon, "SetMode%CreateContainmentMode", 1, "diagramview.button.package.drop_down_relation");
            this.a.setCallMode(true);
            this.a.setModeType(0);
        }
        this.setupIconButton((GIconButton)this.a);
    }

    private void e() {
        if (this.a != null) {
            Pnt2d pnt2d = this.f();
            if (pnt2d == null) {
                this.removeIconButton((GIconButton)this.a);
                this.a = null;
            } else {
                this.addIconButton((GIconButton)this.a);
                this.a.setPoint(pnt2d);
            }
        }
    }

    private Pnt2d f() {
        PackagePresentation packagePresentation = (PackagePresentation)((UserObject)this.getModel()).getPresentation();
        return IconButtonPositionUtil.getBasicDropDownButtonPoint((LabelPresentation)packagePresentation, this.a);
    }

    @Override
    protected Object[] getLastIconInfo() {
        return b;
    }

    public static void setLastIconInfo(Object[] objectArray) {
        b = objectArray;
    }

    @Override
    public void setBodyRimmedPick(boolean bl) {
        this.frame.setRimmedPick(bl);
    }

    @Override
    public boolean isBodyRimmedPick() {
        return this.frame.isRimmedPick();
    }
}

