/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jviewElement;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.jmodel.LinePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.StyleSupport;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jviewElement.JomtViewElement;
import org.eclipse.emf.common.notify.Notifier;

public class LineViewElement
extends JomtViewElement {
    private GArrow a;
    private static final byte b = 2;
    private static final byte c = 7;

    public LineViewElement(LinePresentation linePresentation) {
        UserObject userObject = new UserObject(null, (Presentation)linePresentation);
        this.setModel(userObject);
        this.setDepth(linePresentation.getDepth());
        this.init();
        this.update();
    }

    public void init() {
        LinePresentation linePresentation = (LinePresentation)((UserObject)this.getModel()).getPresentation();
        int n2 = linePresentation.getDepth();
        Pnt2d[] pnt2dArray = new Pnt2d[]{linePresentation.getStartLocation(), linePresentation.getEndLocation()};
        if (this.a == null) {
            this.a = new GArrow();
            this.a.setPoints(pnt2dArray);
            this.updateLineTypeAndArrow();
            int n3 = 0;
            n3 |= 1;
            this.a.setType(n3 |= 0x100);
            this.a.setDepth(n2 - 1);
            this.a.setModel(this.getModel());
            this.a.setRimmedPick(true);
            this.a.addNodeSelectionListener((GNodeSelectionListener)this.a);
            this.a.addNodeSelectionListener((GNodeSelectionListener)this);
            this.addNode((GNode)this.a, true);
        }
        this.updateColor();
        this.updateSelectionType();
    }

    public void updateLineTypeAndArrow() {
        LinePresentation linePresentation = (LinePresentation)((UserObject)this.getModel()).getPresentation();
        this.a.setRimPatternScale(5);
        this.a.setRimPattern(StyleSupport.getLineTypeByte((IStyleMapOwner)linePresentation));
        this.a.setType(0, StyleSupport.getLineStartArrowInt((IStyleMapOwner)linePresentation));
        this.a.setType(1, StyleSupport.getLineEndArrowInt((IStyleMapOwner)linePresentation));
    }

    @Override
    public void updateColor() {
        LinePresentation linePresentation = (LinePresentation)((UserObject)this.getModel()).getPresentation();
        this.a.setKnobColorNo((byte)2);
        this.a.setForegroundColor(StyleSupport.getLineColorWithAuto((DiagramElement)linePresentation));
        this.a.setShadowColorNo((byte)7);
    }

    @Override
    public void updateSelectionType() {
        this.a.setSelectionType((byte)3);
    }

    public void update(Notifier notifier, Object object) {
        LinePresentation linePresentation = (LinePresentation)((UserObject)this.getModel()).getPresentation();
        if (!linePresentation.isValid()) {
            return;
        }
        this.update();
    }

    @Override
    public void update() {
        LinePresentation linePresentation = (LinePresentation)((UserObject)this.getModel()).getPresentation();
        this.setDepth(linePresentation.getDepth());
        this.updateDepth();
        this.init();
        this.updateLineTypeAndArrow();
        this.updateLineWidth();
        Pnt2d[] pnt2dArray = new Pnt2d[]{linePresentation.getStartLocation(), linePresentation.getEndLocation()};
        this.a.setPoints(pnt2dArray);
    }

    public void updateDepth() {
        int n2 = this.getDepth();
        this.a.setDepth(n2 - 1);
    }

    public void updateLineWidth() {
        LinePresentation linePresentation = (LinePresentation)((UserObject)this.getModel()).getPresentation();
        this.a.setRimWidth(StyleSupport.getLineWidthWithAuto((IStyleMapOwner)linePresentation));
    }

    public boolean intersect(Rectangle2d rectangle2d) {
        if (rectangle2d.isEmpty()) {
            return true;
        }
        if (this.a == null) {
            return false;
        }
        return this.a.intersect(rectangle2d);
    }
}

