/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.swing;

import java.awt.Container;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.SwingGroupUIViewPeer;
import net.astah.golf.widget.CContainer;
import net.astah.golf.widget.CInternalFrame;
import net.astah.golf.widget.CJComponent;
import net.astah.golf.widget.swing.SwingContainer;
import net.astah.golf.widget.swing.SwingInternalFrame;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jview.EditorPeer;
import net.astah.jomt.jview.swing.SwingEditorPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public abstract class SwingEditorPeer
extends SwingGroupUIViewPeer
implements EditorPeer {
    protected JInternalFrame frame;
    protected SwingEditorPrinter printer;
    private static final Logger a = LoggerFactory.getLogger(SwingEditorPeer.class);
    protected static final double FRAME_ICON_SCALE = 1.0;

    @Override
    public void removeFrame() {
        this.frame.getContentPane().removeAll();
        this.frame.dispose();
    }

    @Override
    public void maximize() {
        if (ViewGlobal.isSilentMode) {
            return;
        }
        try {
            if (!this.frame.isMaximum()) {
                this.frame.setMaximum(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setMaximum(boolean bl) {
        try {
            this.frame.setMaximum(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            a.error("error has occurred.", (Throwable)propertyVetoException);
        }
    }

    @Override
    public CInternalFrame createFrame(CJComponent cJComponent) {
        return this.createFrame(cJComponent, true);
    }

    @Override
    public CInternalFrame createFrame(CJComponent cJComponent, boolean bl) {
        Container container = (Container)((SwingContainer)cJComponent).getComponent();
        JInternalFrame jInternalFrame = new JInternalFrame("", true, true, true, true);
        if (GolfUtilities.isMacOS()) {
            jInternalFrame.putClientProperty("JInternalFrame.frameType", "normal");
        }
        SwingInternalFrame swingInternalFrame = new SwingInternalFrame(jInternalFrame);
        jInternalFrame.setSize(container.getSize());
        jInternalFrame.setVisible(bl);
        container.add(jInternalFrame);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return swingInternalFrame;
    }

    @Override
    public CContainer getContainer() {
        return new SwingContainer((Container)this.frame);
    }

    protected void hideTitleBarOfEditorFrame() {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.hide_title_bar_of_editor_frame");
        if (bl) {
            BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.frame.getUI();
            basicInternalFrameUI.setNorthPane(null);
            this.frame.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public Printable getMultiPrintable() {
        if (this.printer != null) {
            return this.printer.getMultiPrintable();
        }
        return null;
    }

    public int getNumbersOfPrintable(PageFormat pageFormat) {
        if (this.printer != null) {
            return this.printer.getNumbersOfPrintable(pageFormat);
        }
        return 0;
    }

    public Printable getPrintable() {
        if (this.printer != null) {
            return this.printer.getPrintable();
        }
        return null;
    }
}

