# 行政によるオープンソースソフトウェア公開活動の国際比較調査報告書　分析用データ

## 概要

本データセットは、独立行政法人情報処理推進機構（IPA）が公開したレポート **「行政によるオープンソースソフトウェア公開活動の国際比較調査報告書　GitHubにおける各国政府機関リポジトリの定量的分析」** において使用された分析データです。

GitHub上で公開されている各国政府機関の公式アカウントおよび関連組織のリポジトリを対象に、異なる時点で取得した2系列のスナップショットデータを整備し、オープンソースソフトウェア（OSS）公開活動の量的傾向を比較できる形にまとめています。


## データセット構成

| ファイル名                                | 内容                                       | データ取得期間                                    | 主キー                               | 関係           |
| ------------------------------------ | ---------------------------------------- | ------------------------------------------ | --------------------------------- | ------------ |
| **organization_master.csv**          | 対象となる政府機関のGitHub組織アカウント情報（マスタ）       | 固定（2025年度調査時点）                     | `organization_id`                 | 各統計データの基点    |
| **github_org_stats_firstcommit.csv** | スナップショットA：主に2025年9月末〜10月初旬に取得した時点のリポジトリ統計情報   | 2025/9/30–2025/10/3, 2025/12/17–2025/12/18 | (`organization_id`, `repository`) | 組織マスタと1対多で対応 |
| **github_org_stats_pr.csv**          | スナップショットB：2025年9月および12月に取得した時点のリポジトリ統計情報 | 2025/9/16–2025/9/24, 2025/12/17–2025/12/18 | (`organization_id`, `repository`) | 組織マスタと1対多で対応 |

※ 両データはそれぞれ独立したスナップショット（観測時点データ）であり、期間の差異によりリポジトリ数が完全に一致しない場合があります。


## データ項目定義

### 1. organization_master.csv

| カラム名                 | 内容                         | 型      | 例     |
| -------------------- | -------------------------- | ------ | ----- |
| organization_id      | 組織識別子（内部一意）                | int    | 12    |
| organization_account | GitHub組織アカウント名             | string | govuk |
| repository_count     | 対象リポジトリ数                   | int    | 53    |
| country_code         | 国名コード（ISO 3166-1 alpha-2形式） | string | GB    |


### 2. github_org_stats_firstcommit.csv（スナップショットA）

| カラム名              | 内容                       | 型                 | 例              |
| ----------------- | ------------------------ | ----------------- | -------------- |
| organization_id   | 組織識別子（マスタと対応）            | int               | 12             |
| repository        | リポジトリ名                   | string            | govuk-frontend |
| star              | スター数（スナップショットA時点）        | int               | 1420           |
| fork              | フォーク数（同時点）               | int               | 205            |
| branch            | ブランチ数（同時点）               | int               | 8              |
| people            | コミット参加者数（同時点）         | int               | 24             |
| first_commit_date | 初回コミット日時                | string (ISO 8601) | 2015-09-01T09:30:00Z     |


### 3. github_org_stats_pr.csv（スナップショットB）

| カラム名            | 内容                | 型      | 例              |
| --------------- | ----------------- | ------ | -------------- |
| organization_id | 組織識別子（マスタと対応）     | int    | 12             |
| repository      | リポジトリ名            | string | govuk-frontend |
| star            | スター数（スナップショットB時点） | int    | 1456           |
| fork            | フォーク数（同時点）        | int    | 210            |
| branch          | ブランチ数（同時点）        | int    | 8              |
| people          | コミット参加者数（同時点）     | int    | 24             |
| issue           | Issue総数（同時点）           | int    | 158            |
| pull_request    | Pull Request総数（同時点）    | int    | 233            |
| contributor     | コントリビューター数（同時点） | int    | 45             |


## データ作成方法

* **対象**：各国政府および行政機関のGitHub公式組織アカウント
* **取得方法**：GitHub APIを用い、組織単位でリポジトリメタデータを収集
* **取得時点**：
  * スナップショットA（`github_org_stats_firstcommit.csv`）：2025/9/30–10/3および12/17–12/18
  * スナップショットB（`github_org_stats_pr.csv`）：2025/9/16–9/24および12/17–12/18
* **対象国**：日本、エストニア、シンガポール、ドイツ、フランス、米国、英国
* **目的**：政府機関によるOSS公開活動を時点比較・国際比較可能な形式で整備


## 主キー・リレーション構造

| ファイル                             | 主キー                               | 外部キー                                    |
| -------------------------------- | --------------------------------- | --------------------------------------- |
| organization_master.csv          | `organization_id`                 | -                                       |
| github_org_stats_firstcommit.csv | (`organization_id`, `repository`) | `organization_id` → organization_master |
| github_org_stats_pr.csv          | (`organization_id`, `repository`) | `organization_id` → organization_master |


## 分析上の留意点

* 両スナップショットは異なる日付範囲で取得されており、API応答タイミングやリポジトリの更新により数値差が生じる可能性があります。
* 削除・非公開化リポジトリは含まれません。
* すべての日時はUTC基準です。
* 比較分析時には、**取得期間の重複および差異を考慮**することを推奨します。


## 更新履歴・バージョン情報

| 項目      | 内容                                                                                                                      |
| ------- | ----------------------------------------------------------------------------------------------------------------------- |
| データ取得期間 | - スナップショットA（firstcommit.csv）: 2025/9/30–10/3, 2025/12/17–12/18<br>- スナップショットB（pr.csv）: 2025/9/16–9/24, 2025/12/17–12/18 |
| 対象国     | 日本、エストニア、シンガポール、ドイツ、フランス、米国、英国                                                                                        |
| データ公開日  | 2026年1月28日                                                                                                                |
| 更新予定    | 未定                                                                                                         |


## ライセンス

本データセットは [Creative Commons Attribution 4.0 International License(CC BY 4.0)](https://creativecommons.org/licenses/by/4.0/deed.ja) の下に提供されています。
出典を明記すれば、商用・非商用を問わず自由に利用可能です。

引用例：

> 独立行政法人情報処理推進機構（IPA）「行政によるオープンソースソフトウェア公開活動の国際比較調査報告書　GitHubにおける各国政府機関リポジトリの定量的分析」分析用データ（2026年）


## 免責事項

本データセットは、その内容に関する有用性、正確性、知的財産権の不侵害等の一切について、当組織が如何なる保証をするものではありません。


## お問い合わせ

独立行政法人情報処理推進機構（IPA）

デジタル基盤センター

Email: disc-info@ipa.go.jp
